<?php
/**
# ################################################################################
# Project:   PHP Link Directory: Version 3.1
#
# **********************************************************************
# Copyright (C) 2004-2006 NetCreated, Inc. (http://www.netcreated.com/)
#
# This software is for use only to those who have purchased a license.
# A license must be purchased for EACH installation of the software.
#
# By using the software you agree to the terms:
#
#    - You may not redistribute, sell or otherwise share this software
#      in whole or in part without the consent of the the ownership
#      of PHP Link Directory. Please contact david@david-duval.com
#      if you need more information.
#
#    - You agree to retain a link back to http://www.phplinkdirectory.com/
#      on all pages of your directory in you purchased the $25 version
#      of the software.
#
# License holders are entitled to upgrades to the 3.0 branch of the software
# as they are made available at ttp://www.phplinkdirectory.com/
#
# In some cases, license holders may be required to agree to changes
# in the software license before receiving updates to the software.
# **********************************************************************
#
# For questions, help, comments, discussion, etc., please join the
# PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
#
# @link           http://www.phplinkdirectory.com/
# @copyright      2004-2006 NetCreated, Inc. (http://www.netcreated.com/)
# @projectManager David DuVal <david@david-duval.com>
# @package        PHPLinkDirectory
# @version        3.1 (=3.0.7)
# ################################################################################
*/

require_once 'init.php';

// Check page request, if not valid a http header 404 is sent
$http_status = (!empty ($_REQUEST['httpstatus']) ? intval ($_REQUEST['httpstatus']) : request_status());
@httpstatus($http_status);

// Determine user ID to search for, but only if valid user
if (!empty ($_SESSION['regular_user_id']))
{
   $uid = (!empty ($_REQUEST['uid']) && preg_match ('`^[\d]+$`', $_REQUEST['uid']) ? intval ($_REQUEST['uid']) : 0);
   if ($uid > 0 && $uid == $_SESSION['regular_user_id'])
      $user_where = " AND `OWNER_ID` = ".$db->qstr($uid);
   else
      unset ($uid);
}

// Determine page number and current page index
if (ENABLE_REWRITE == 1 && !isset ($_REQUEST['search']) && empty ($_REQUEST['s'])) // Rewrited page links
{
   preg_match ("/page-(\d+)\.htm[l]?([?]?.*)$/", request_uri(), $matches);
   // Determine current index
   $page         = (!empty($matches[1]) ? intval ($matches[1]) : 1);
   // Determine page
   $current_item = PAGER_LPP * $page - PAGER_LPP;

   unset ($matches);
}
else // Regular page links
{
   // Determine current index
   $current_item = (!empty ($_REQUEST['p']) && preg_match ('`^[\d]+$`', $_REQUEST['p']) ? intval ($_REQUEST['p']) : 1);
   $current_item--;
   // Determine page
   $page         = ceil ($current_item / PAGER_LPP);
}

$page = ($page < 1 ? 1 : $page); // Check again for negative page

// Remove rewrite page link
//$_SERVER['REQUEST_URI'] = preg_replace("/page-(\d+)\.htm[l]?$/", "", $_SERVER['REQUEST_URI']);
$pattern = array ("/page-(\d+)\.htm[l]?/", '`([?]|[&])(p=)+[\d]*`', '`([?]|[&])(cat_page=)+[\d]*`');
$_SERVER['REQUEST_URI'] = preg_replace ($pattern, '', request_uri());

// Define sorting options
define ('DIR_LPP', 20);
$sort_cols = array ('P' => 'PAGERANK', 'H' => 'HITS', 'A' => 'TITLE', 'D' => 'DATE_ADDED');
$sort_ord  = array ('P' => 'DESC'    , 'H' => 'DESC', 'A' => 'ASC'  , 'D' => 'DESC'      );

// Build limit query
$limit = ' LIMIT '.($current_item <= 1 ? '0' : $current_item).', '.PAGER_LPP;

$getSort = (!empty ($_REQUEST['s']) ? trim ($_REQUEST['s']) : (!empty ($URLvariables['s']) ? $URLvariables['s'] : ''));

if (array_key_exists ($getSort, $sort_cols))
   $sort = $getSort;
else
   $sort = DEFAULT_SORT;

if (ENABLE_PAGERANK != 1 || SHOW_PAGERANK != 1 && $sort == 'P')
   $sort = 'H';

$tpl->assign('sort', $sort);
$path    = array ();
$path[]  = array ('ID' => '0', 'TITLE' => _L(SITE_NAME), 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => SITE_DESC);

// Query to not have feat. links in results
if (FTR_ENABLE == 1)
   $feat_where = "AND (`FEATURED` = '0')";

// Query for not exprired links
$expire_where = "AND (`EXPIRY_DATE` >= ".$db->DBDate(time())." OR `EXPIRY_DATE` IS NULL)";

// Option to turn link hits increment On/Off
$StopLinkHits = 0;

if (isset ($_REQUEST['list'])) // Top pages listings
{
   $StopLinkHits = 1; // Disable link hits
   switch ($_REQUEST['list'])
   {
      case 'latest':
         $links = $db->GetAll ("SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$expire_where} ORDER BY `DATE_ADDED` DESC LIMIT 0, ".LINKS_TOP);
         $path[] = array ('ID' => '0', 'TITLE' => _L('Latest Links'), 'TITLE_URL' => '', 'DESCRIPTION' => '');
         break;
      case 'top':
         $links = $db->GetAll ("SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$expire_where} ORDER BY `HITS` DESC LIMIT 0, ".LINKS_TOP);
         $path[] = array ('ID' => '0', 'TITLE' => _L('Top Hits'), 'TITLE_URL' => '', 'DESCRIPTION' => '');
         break;
      default:
         http_redirect(DOC_ROOT);
         break;
   }
   $tpl->assign('list', $_REQUEST['list']);
}
elseif (!empty ($user_where) && !empty ($uid)) // Registered user links listings
{
      if (FTR_ENABLE == 1)
      {
         $feat_links = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' AND `FEATURED` = '1' {$expire_where} {$user_where} ORDER BY `EXPIRY_DATE` DESC");
      }

      $count = $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$expire_where} {$user_where} ORDER BY `{$sort_cols[$sort]}` {$sort_ord[$sort]}");

      $links = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$feat_where} {$expire_where} {$user_where} ORDER BY `{$sort_cols[$sort]}` {$sort_ord[$sort]}");

      $tpl->assign('have_search_results', 1);
      $tpl->assign('uid', $uid);

      $path[] = array ('ID' => '0', 'TITLE' => _L('Personal links'), 'TITLE_URL' => '', 'DESCRIPTION' => _L('Search results for personal links'));
}
elseif (!empty ($_REQUEST['search'])) // Search results
{
   require_once 'search.php';

   $search_preferences = array ();
   $search_preferences['Select_Options']  = array ( '`ID`'                      ,
                                                    '`TITLE`'                   ,
                                                    '`CACHE_TITLE`'             ,
                                                    '`CACHE_URL`'
                                                    );
   $search_preferences['Where_Options']   = array ( "`STATUS` = '2'"            ,
                                                    "`CACHE_TITLE` IS NOT NULL" ,
                                                    "`CACHE_URL` IS NOT NULL"
                                                    );
   $search_preferences['Order_Options']   = array ( "`ID` ASC"                  ,
                                                    "`PARENT_ID` ASC"           ,
                                                    "`TITLE` ASC"               ,
                                                    "`CACHE_TITLE` ASC"
                                                    );
   $search_preferences['Search_Location'] = array ( 'TITLE' );
   $search_preferences['From_Table']      = $tables['category']['name'];
   $search_preferences['BooleanSearchActive'] = 0;

   $CategorySearchResults = search($search_preferences);

   $tpl->assign('search'      , $CategorySearchResults['search']);
   $tpl->assign('search_terms', $CategorySearchResults['search']);

   if (empty ($CategorySearchResults['errors']['empty_search']))
   {

      $num_categs_per_page = 5;
      $categs_page_limit   = 3;

      $CountCategResults = $db->GetOne($CategorySearchResults['SQL_Count_All']);
      $CountCategResults = (empty ($CountCategResults) || $CountCategResults < 0 ? 0 : intval ($CountCategResults));

      if (!empty ($CountCategResults))
      {
         $start_query = (!empty($_REQUEST['cat_page']) && preg_match('`^[\d]+$`', $_REQUEST['cat_page']) ? intval ($_REQUEST['cat_page']) : 1);

         $ListCategs = $db->GetAll($CategorySearchResults['SQL_Query']." LIMIT ".($start_query <= 1 ? '0' : $start_query).", {$num_categs_per_page}");

         // Start category paging
         SmartyPaginate :: connect('CategoryPaging'); // Connect Paging
         if ($CountCategResults < 2)
         {
            SmartyPaginate :: disconnect('CategoryPaging');
            SmartyPaginate :: reset     ('CategoryPaging');
         }

         SmartyPaginate :: setPrevText    ('['._L('...less') .']' , 'CategoryPaging');
         SmartyPaginate :: setNextText    ('['._L('more...').']'  , 'CategoryPaging');
         SmartyPaginate :: setFirstText   ('['._L('First').']'    , 'CategoryPaging');
         SmartyPaginate :: setLastText    ('['._L('Last').']'     , 'CategoryPaging');
         SmartyPaginate :: setTotal       ($CountCategResults     , 'CategoryPaging');
         SmartyPaginate :: setUrlVar      ('cat_page'             , 'CategoryPaging');
         SmartyPaginate :: setUrl         ($_SERVER['REQUEST_URI'], 'CategoryPaging');
         SmartyPaginate :: setCurrentItem ($start_query           , 'CategoryPaging');
         SmartyPaginate :: setLimit       ($num_categs_per_page   , 'CategoryPaging');
         SmartyPaginate :: setPageLimit   ($categs_page_limit     , 'CategoryPaging');
         SmartyPaginate :: assign         ($tpl                   , 'CategoryPaging', 'CategoryPaging');

            $tpl->assign('list_cat', $ListCategs);
            if (!empty ($ListCategs))
            {
               $search_cat = $tpl->fetch('category_search.tpl');
               $tpl->assign('search_category', $search_cat);
            }
      }
   } // End category search
   unset ($CategorySearchResults, $search_preferences, $ListCategs, $categs_page_limit, $num_categs_per_page, $start_query, $search_cat);

   if (FTR_ENABLE) {
      $search_preferences = array ();
      $search_preferences['Select_Options']  = array ( '*' );
      $search_preferences['Where_Options']   = array ( "`STATUS` = '2'"   ,
                                                       "`FEATURED` = '1'" ,
                                                       "(`EXPIRY_DATE` >= ".$db->DBDate(time())." OR `EXPIRY_DATE` IS NULL)"
                                                       );
      $search_preferences['Order_Options']   = array ( "`EXPIRY_DATE` DESC"
                                                       );
      $search_preferences['Search_Location'] = array ( 'URL'               ,
                                                       'TITLE'             ,
                                                       'DESCRIPTION'
                                                        );
      $search_preferences['From_Table']      = $tables['link']['name'];
      //$search_preferences['BooleanSearchActive'] = 1; // Default to regular search

      $FeatLinksResults = search($search_preferences);

      if (empty ($FeatLinksResults['errors']['empty_search']))
      {
         $feat_links = $db->GetAll($FeatLinksResults['SQL_Query']);
         $CountFeatLinksResults = $db->Affected_Rows();
         if (empty ($CountFeatLinksResults))
            unset ($feat_links);
      }
   } // End featured links search
   unset ($search_preferences, $FeatLinksResults);

   $search_preferences = array();
   $search_preferences['Select_Options']  = array ( '*' );
   $search_preferences['Where_Options']   = array ( "`STATUS` = '2'"            ,
                                                    "`FEATURED` = '0'" ,
                                                    "(`EXPIRY_DATE` >= ".$db->DBDate(time())." OR `EXPIRY_DATE` IS NULL)"
                                                    );
   $search_preferences['Order_Options']   = array ( '`'.$sort_cols[$sort].'` '.$sort_ord[$sort]
                                                       );

   $search_preferences['Search_Location'] = array ( 'URL'               ,
                                                    'TITLE'             ,
                                                    'DESCRIPTION'
                                                     );

   $search_preferences['From_Table']      = $tables['link']['name'];
   //$search_preferences['BooleanSearchActive'] = 0;

   $LinksResults = search($search_preferences);

   $count = $db->GetOne($LinksResults['SQL_Count_All']);

   if (!empty ($count))
      $links = $db->GetAll($LinksResults['SQL_Query'].$limit);

   if (!empty ($count) || !empty ($CountFeatLinksResults) || !empty ($CountCategResults))
      $tpl->assign('have_search_results', 1);
   else
      $tpl->assign('have_search_results', 0);

   unset ($LinksResults, $search_preferences, $CountFeatLinksResults, $CountCategResults);

   $categs = array ();
   $path[] = array ('ID' => '0', 'TITLE' => _L('Search Results'), 'TITLE_URL' => '', 'DESCRIPTION' => _L('Search results for: ').$_REQUEST['search']);
}
else // Regular listing, categories and links
{
   $id = get_category();

   if ($id > 0)
      $meta_tags = $db->GetRow("SELECT `META_KEYWORDS`, `META_DESCRIPTION` FROM `{$tables['category']['name']}` WHERE `ID` = ".$db->qstr($id));

   if (!$tpl->is_cached('main.tpl', $id))
   {

      $path = get_path($id);

      if (FTR_ENABLE == 1)
      {
         $feat_links = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$bydate} AND `CATEGORY_ID` = ".$db->qstr($id)." AND `FEATURED` = 1 {$expire_where} ORDER BY `EXPIRY_DATE` DESC");
      }

      $count = $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$bydate} AND `CATEGORY_ID` = ".$db->qstr($id)." {$feat_where} {$expire_where}");

      $links = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$bydate} AND `CATEGORY_ID` = ".$db->qstr($id)." {$feat_where} {$expire_where} ORDER BY `{$sort_cols[$sort]}` {$sort_ord[$sort]} {$limit}");

      $rs = $db->Execute("SELECT * FROM `{$tables['category']['name']}` WHERE `STATUS` = '2' AND PARENT_ID = ".$db->qstr($id)." ORDER BY `TITLE`");

      while (!$rs->EOF)
      {
         $row = $rs->FetchRow();
         if ($id == 0 && CATS_PREVIEW > 0)
         {
            $rs2 = $db->SelectLimit("SELECT * FROM `{$tables['category']['name']}` WHERE `STATUS` = '2' AND `SYMBOLIC` <> '1' AND `PARENT_ID` = ".$db->qstr($row['ID'])." ORDER BY `HITS` DESC, `TITLE` ", CATS_PREVIEW);
            $row['SUBCATS'] = $rs2->GetRows();
            $rs2->Close();
         }
         if (ENABLE_REWRITE == 1 && empty ($row['TITLE_URL']))
         {
            $row['TITLE_URL'] = preg_replace ('`[^\w_-]`', '_', $row['TITLE']);
            $row['TITLE_URL'] = str_replace ('__', '_', $row['TITLE_URL']);
         }

         if ($row['SYMBOLIC'] == 1)
         {
            $row['ID'] = $row['SYMBOLIC_ID'];
            $tempcat = $db->GetRow("SELECT * FROM `{$tables['category']['name']}` WHERE `ID` = ".$db->qstr($row['SYMBOLIC_ID']));
            if (empty ($row['TITLE']))
               $row['TITLE'] = $tempcat['TITLE'];

            $row['TITLE'] = "@" . $row['TITLE'];

            if (ENABLE_REWRITE == 1)
               $row['TITLE_URL'] = construct_mod_rewrite_path($row['SYMBOLIC_ID']);

            $row['COUNT'] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['category']['name']}` WHERE `STATUS` = '2' AND `PARENT_ID` = ".$db->qstr($row['SYMBOLIC_ID']));
            $row['COUNT'] += $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' AND `CATEGORY_ID` = ".$db->qstr($row['SYMBOLIC_ID']));
         }
         else
         {
            $row['COUNT'] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['category']['name']}` WHERE `STATUS` = '2' AND `PARENT_ID` = ".$db->qstr($row['ID']));
            $row['COUNT'] += $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' AND `CATEGORY_ID` = ".$db->qstr($row['ID']));
         }

         $categs[] = $row;
      }
      $rs->Close();
   }
   if ($id > 0)
   {
      $HitInfo = $db->GetRow("SELECT * FROM `{$tables['hitcount']['name']}` WHERE `CATEGORY_ID` = ".$db->qstr($id)." AND `IP` = ".$db->qstr($client_info['IP']));

      if (!empty ($HitInfo))
      {
         $current_time = date ('Y-m-d H:i:s');
         $SecondsDiff  = dateTimeDifference($current_time, $HitInfo['LAST_HIT']);
         $Diff         = second2hour($SecondsDiff);

         if ($Diff > LIMIT_HITS_TIME)
         {
            $db->Execute("UPDATE `{$tables['category']['name']}` SET `HITS` = `HITS` + 1 WHERE `ID` = ".$db->qstr($id));
            $where = '`ID` = '.$db->qstr($HitInfo['ID']);
            $HitInfo['LAST_HIT'] = $current_time;
            $db->AutoExecute($tables['hitcount']['name'], $HitInfo, 'UPDATE', $where);
         }
      }
      else
      {
         $db->Execute("UPDATE `{$tables['category']['name']}` SET `HITS` = `HITS` + 1 WHERE `ID` = ".$db->qstr($id));
         $HitInfo['CATEGORY_ID'] = $id;
         $HitInfo['IP']         = $client_info['IP'];
         $db->AutoExecute($tables['hitcount']['name'], $HitInfo, 'INSERT', false);
      }

      unset ($HitInfo, $current_time, $Diff, $SecondsDiff);
   }

   /*$tpl->assign('title_prefix', $path[count($path) - 1]['TITLE']." - ");*/

   if ($page > 1)
      $path[] = array ('ID' => $id, 'TITLE' => _L('Page ' . $page), 'TITLE_URL' => '', 'DESCRIPTION' => '');
}

//Add cached category URL and title for featured links
if (FTR_ENABLE == 1 && isset ($feat_links))
{
   $feat_links = addCategPathToLinks($feat_links);
   $tpl->assign('feat_links', $feat_links);
}
//Add cached category URL and title for regular links
if (isset ($links))
{
   $links = addCategPathToLinks($links);
}

$count          = (empty ($count) || $count < 0 ? 0 : intval ($count));
$PagerGroupings = (PAGER_GROUPINGS && PAGER_GROUPINGS > 0 ? intval (PAGER_GROUPINGS) : 20);
$LinksPerPage   = (PAGER_LPP       && PAGER_LPP       > 0 ? intval (PAGER_LPP)       : 10);

if (empty ($_REQUEST['list'])) //Build paging options
{
   SmartyPaginate :: connect('MainPaging'); //Connect Paging

   // Build Paging
   if ($page < 2)
   {
      SmartyPaginate :: disconnect('MainPaging');
      SmartyPaginate :: reset     ('MainPaging');
   }

   SmartyPaginate :: setPrevText    ('Previous'              , 'MainPaging');
   SmartyPaginate :: setNextText    ('Next'                  , 'MainPaging');
   SmartyPaginate :: setFirstText   ('First'                 , 'MainPaging');
   SmartyPaginate :: setLastText    ('Last'                  , 'MainPaging');
   SmartyPaginate :: setTotal       ($count                  , 'MainPaging');
   SmartyPaginate :: setUrlVar      ('p'                     , 'MainPaging');
   SmartyPaginate :: setUrl         ($_SERVER['REQUEST_URI'] , 'MainPaging');
   SmartyPaginate :: setCurrentItem ($current_item + 1       , 'MainPaging');
   SmartyPaginate :: setLimit       ($LinksPerPage           , 'MainPaging');
   SmartyPaginate :: setPageLimit   ($PagerGroupings         , 'MainPaging');
   SmartyPaginate :: assign         ($tpl                    , 'MainPaging', 'MainPaging');
}

// Assign template variables
$tpl->assign('category'       , $path[count ($path) - 1]);
$tpl->assign('path'           , $path);
$tpl->assign('count'          , $count);
$tpl->assign('links'          , $links);
$tpl->assign('categs'         , $categs);
$tpl->assign('p'              , $current_item + 1);
$tpl->assign('StopLinkHits'   , $StopLinkHits);

$tpl->assign('MetaKeywords'   , (!empty ($meta_tags['META_KEYWORDS'])    ? trim ($meta_tags['META_KEYWORDS'])    : trim ($MetaKeywords)));
$tpl->assign('MetaDescription', (!empty ($meta_tags['META_DESCRIPTION']) ? trim ($meta_tags['META_DESCRIPTION']) : trim ($MetaDescription)));

//Rewrite Paging links
if (ENABLE_REWRITE == 1)
   $tpl->load_filter('output', 'RewritePageLinks');

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Compress output for faster loading
if (COMPRESS_OUTPUT == 1)
   $tpl->load_filter('output', 'CompressOutput');

//Make output
$randFeat = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `FEATURED` = '1' AND `STATUS` = '2'  {$expire_where} ORDER BY `DATE_ADDED` DESC LIMIT 5");
$tpl->assign('randFeat', $randFeat);

$fetchfeatlink = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `FEATURED` = '1' AND `STATUS` = '2'  {$expire_where} ORDER BY `DATE_ADDED` ASC LIMIT 1");
$tpl->assign('fetchfeatlink', $fetchfeatlink);
require_once 'statistics.php';
echo $tpl->fetch('main.tpl', $id);
?>